<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1\Interaction\InteractionChannel;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class InteractionChannelParticipantContext extends InstanceContext {
    /**
     * Initialize the InteractionChannelParticipantContext
     *
     * @param Version $version Version that contains the resource
     * @param string $interactionSid The Interaction Sid for this channel.
     * @param string $channelSid The Channel Sid for this Participant.
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, $interactionSid, $channelSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['interactionSid' => $interactionSid, 'channelSid' => $channelSid, 'sid' => $sid, ];

        $this->uri = '/Interactions/' . \rawurlencode($interactionSid) . '/Channels/' . \rawurlencode($channelSid) . '/Participants/' . \rawurlencode($sid) . '';
    }

    /**
     * Update the InteractionChannelParticipantInstance
     *
     * @param string $status The Participant's status.
     * @return InteractionChannelParticipantInstance Updated
     *                                               InteractionChannelParticipantInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $status): InteractionChannelParticipantInstance {
        $data = Values::of(['Status' => $status, ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new InteractionChannelParticipantInstance(
            $this->version,
            $payload,
            $this->solution['interactionSid'],
            $this->solution['channelSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InteractionChannelParticipantContext ' . \implode(' ', $context) . ']';
    }
}